﻿//////////////////////////////////////////////
// ShaderResourceDesc.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class ConstantBuffer ;
	class Sampler ;
	class ShaderResource ;
}

/// Class ------------------------------------

namespace nkGraphics
{
	// Shader bound resource description
	template <typename T>
	class ShaderBoundResourceDesc
	{
		public :
			
			// Constructors
			ShaderBoundResourceDesc () noexcept = default ;

			ShaderBoundResourceDesc (unsigned int slot, unsigned int space, T* resource) noexcept
			:	_slot (slot),
				_space (space),
				_resource (resource)
			{
				// Nothing to do
			}

		public :

			// Attributes
			unsigned int _slot ;
			unsigned int _space ;

			T* _resource ;
	} ;

	// Typedefs des usages
	using ConstantBufferResourceDesc = ShaderBoundResourceDesc<ConstantBuffer> ;
	using ShaderResourceDesc = ShaderBoundResourceDesc<ShaderResource> ;
	using UavResourceDesc = ShaderBoundResourceDesc<Buffer> ;
	using SamplerResourceDesc = ShaderBoundResourceDesc<Sampler> ;
}